/*
 *  Fromage  v 1.0  19/06/02
 *	
 *  Auteur: Didier STRAUS  
 *
 *  email: Software-DS@wanadoo.fr
 *
 *  http://www.Softwrae-DS.com
 *
 *  Ce programme fontionne sur MacOS X uniquement.
 *
 *  Ce programme permet d'obtenir un camembert  partir
 *  des nombres saisis. possibilit de sauvegarder l'image
 *  obtenu au format Pict Vectoriel.
 *
 */

#include <stdio.h>
#include <carbon.h>
#define max 10 /* nombre de valeurs au maxi */
#define rWindow	128	/* rfrence de la fenetre du fichier ressource */

/* Dfinition des couleurs */

RGBColor kBlanc		= { 0xFFFF, 0xFFFF, 0xFFFF };
RGBColor kNoir		= { 0x0000, 0x0000, 0x0000 };
RGBColor kRouge 	= { 0xAAAA, 0x0000, 0x0000 };
RGBColor kJaune 	= { 0xFFFF, 0xCCCC, 0x0000 };
RGBColor kVert 		= { 0x0000, 0x9999, 0x0000 };
RGBColor kBleue 	= { 0x6666, 0x6666, 0x9999 };
RGBColor kRouge2 	= { 0xFFFF, 0x0000, 0x0000 };
RGBColor kBleue2 	= { 0x6666, 0x6666, 0xFFFF };
RGBColor kVert2 	= { 0x0000, 0xFFFF, 0x0000 };
RGBColor kOrange 	= { 0xFFFF, 0x6666, 0x0000 };
RGBColor kGris 		= { 0x9999, 0x9999, 0x9999 };

OSErr Pict2File(PicHandle thePicture); /* prototype */


int main(void){  /* MAIN */
	int 		i,j,k,x,val,tot=0,angle=360;
	int 		t[max];
	float 		a;
	WindowRef	gWindowRef;
	Rect 		theRect,drawingRect,pictureRect;
	PolyHandle 	polygonHdl;
	Str255		theString;
	PicHandle	thePic;
	
	do{
		printf("Combien de valeurs avez vous ? (1  %d)\n",max);
		scanf("%d",&i);
	} while((i<1) || (i>max));
	
	printf("\nEntrez vos %d valeurs:\n\n",max);
	for(j=1;j<=i;j++){ /* saisie des i valeur(s) */
		printf("val(%d)= ",j);
		do{
			scanf("%d",&val);
		} while(val<=0);
		t[j-1]=val;
		tot+=val;
	}
	
	if (i>1) {
		for(k=0;k<(i-1);k++){ /* on va trier le tableau dans l'ordre croissant */
			int mini=t[k];
			for(j=k+1;j<i;j++){
				if (t[j]<mini) {
					mini=t[j];
					t[j]=t[k];
					t[k]=mini;
				}
			}
		}
	}
	
	if(!(gWindowRef = GetNewCWindow(rWindow,NULL,(WindowRef)-1)))
		ExitToShell();
	SetPortWindowPort(gWindowRef);
	
	GetPortBounds(GetWindowPort(gWindowRef),&pictureRect);
	ClipRect(&pictureRect);	/* Pour crer une image vectorielle */

	SetRect(&drawingRect,0,0,540,360); 
	thePic=OpenPicture(&drawingRect); /* Pour mmoriser le dessin dans thePic */
	EraseRect(&pictureRect);
	
	polygonHdl = OpenPoly(); /* definition du polygone */
	MoveTo(5,0); /* on dfini un losange */
	LineTo(10,5);
	LineTo(5,10);
	LineTo(0,5);
	ClosePoly();
	
	OffsetPoly(polygonHdl,350,30);
	x=0;
	for(j=1;j<=i;j++){ /* Dessin du camembert */
		SetRect(&theRect,30,30,280,280);
		if (j==1)
			RGBForeColor(&kVert2);
		else if (j==2)
			RGBForeColor(&kRouge2);
		else if (j==3)
			RGBForeColor(&kBleue2);
		else if (j==4)
			RGBForeColor(&kOrange);
		else if (j==5)
			RGBForeColor(&kRouge);
		else if (j==6)
			RGBForeColor(&kBleue);
		else if (j==7)
			RGBForeColor(&kVert);
		else if (j==8)
			RGBForeColor(&kJaune);
		else if (j==9)
			RGBForeColor(&kGris);
		else if (j==10)
			RGBForeColor(&kNoir);
		a=(t[j-1]*100)/tot;
		a*=3.6;
		if (i==j)
			a=angle;
		else
			angle-=(int) a;

		PaintArc(&theRect,x,(int) a);
		x+=a;
		
		OffsetPoly(polygonHdl,0,20);
		PaintPoly(polygonHdl); /* On dessine un losange de la meme couleur que la part du camembert */
		MoveTo(365,40+j*20);
		NumToString(t[j-1],theString);
		DrawString(theString); /* On crit  cot du losange la valeur de la part du camembert */
	}
	
	KillPoly(polygonHdl);	
	ClosePicture();
	DrawPicture(thePic,&drawingRect); /* le dessin est mmoris dans 'thePic' */
	QDFlushPortBuffer(GetWindowPort(FrontWindow()),NULL); /* pour la mise  jour graphique dans la fenetre */
	
	while (!Button()){}; /* Pause: Attente d'un clic de souris. */
	while (Button()){};
	
	if (Pict2File(thePic)!=0) { /* Sauvegarde de l'image ? */
		SysBeep(5);
	}
	ExitToShell(); /* On quitte */
	return 0;
/* 2002 All Rights Reserved to Didier STRAUS www.Software-DS.com */
}

OSErr Pict2File(PicHandle thePicture) { /* Pour sauvegarder l'image au format Pict Vectoriel */
	OSErr               anErr = noErr;
    NavReplyRecord      reply;
    NavDialogOptions    dialogOptions;
    OSType              fileTypeToSave = 'PICT';
    OSType              creatorType = '????'; /* l'image s'ouvrira avec le logiciel Preview (Aperu) */
	AEKeyword   		theKeyword;
    DescType    		actualType;
    Size        		actualSize;
    FSSpec      		documentFSSpec;
    long				inOutCount;
    short				refNum, count;
    unsigned char 		header[512];
    
    for (count = 0; count < 512; count++)
		header[count] = 0x00;

    anErr = NavGetDefaultDialogOptions(&dialogOptions); 
    dialogOptions.dialogOptionFlags |= kNavSelectDefaultLocation;
    
    anErr = NavPutFile(nil,&reply,&dialogOptions,nil,fileTypeToSave,creatorType,nil);
    if (anErr == noErr && reply.validRecord) {
    	anErr = AEGetNthPtr(&(reply.selection),1,typeFSS,&theKeyword, &actualType,&documentFSSpec,sizeof(documentFSSpec),&actualSize );
  		if (anErr == noErr) {
  	  		anErr = FSpCreate(&documentFSSpec,creatorType,fileTypeToSave,smSystemScript);
			if (anErr == dupFNErr) {
				anErr = FSpDelete(&documentFSSpec);
				anErr = FSpCreate(&documentFSSpec,creatorType,fileTypeToSave,smSystemScript);
			}
    		FSpOpenDF(&documentFSSpec,fsRdWrPerm,&refNum);
    		inOutCount = 512;
   			anErr = FSWrite(refNum,&inOutCount,header);
    		if (anErr == noErr) {
    			inOutCount = GetHandleSize((Handle)thePicture);
				anErr = FSWrite(refNum,&inOutCount,*thePicture);
    		}
    		FSClose(refNum);
  	  }
  	  reply.translationNeeded = false;
  	  anErr = NavCompleteSave(&reply, kNavTranslateInPlace);
 	  NavDisposeReply(&reply);
    }
    return 0;
}
